# Smart Wallet API

API de Controle Financeiro desenvolvida com Flask e SQLAlchemy.

## Funcionalidades

- Autenticação JWT
- CRUD completo de usuários
- CRUD completo de categorias
- CRUD completo de despesas (com suporte a recorrência mensal)
- CRUD completo de receitas (com suporte a recorrência mensal)
- Relatórios financeiros
- Documentação Swagger/OpenAPI
- Paginação em todas as listagens

## Requisitos

- Python 3.8+
- PostgreSQL (ou outro banco de dados suportado pelo SQLAlchemy)

## Instalação

1. Clone o repositório:

```bash
git clone https://github.com/seu-usuario/smart-wallet-api.git
cd smart-wallet-api
```

2. Crie um ambiente virtual e ative-o:

```bash
python -m venv venv
source venv/bin/activate  # Linux/Mac
venv\Scripts\activate  # Windows
```

3. Instale as dependências:

```bash
pip install -r requirements.txt
```

4. Configure as variáveis de ambiente criando um arquivo `.env`:

```
SECRET_KEY=sua-chave-secreta
JWT_SECRET_KEY=sua-chave-jwt
DATABASE_URL=postgresql://usuario:senha@localhost/smart_wallet
```

5. Inicialize o banco de dados:

```bash
flask db init
flask db migrate
flask db upgrade
```

## Executando a API

```bash
python run.py
```

A API estará disponível em `http://localhost:5000` e a documentação Swagger em `http://localhost:5000/swagger-ui`.

## Endpoints

### Autenticação

- POST /api/users/register - Registra um novo usuário
- POST /api/users/login - Login de usuário

### Usuários

- GET /api/users - Lista usuários
- GET /api/users/{id} - Obtém um usuário
- PATCH /api/users/{id} - Atualiza um usuário
- DELETE /api/users/{id} - Remove um usuário

### Categorias

- POST /api/categories - Cria uma categoria
- GET /api/categories - Lista categorias
- GET /api/categories/{id} - Obtém uma categoria
- PATCH /api/categories/{id} - Atualiza uma categoria
- DELETE /api/categories/{id} - Remove uma categoria

### Despesas

- POST /api/expenses - Cria uma despesa
- GET /api/expenses - Lista despesas
- GET /api/expenses/{id} - Obtém uma despesa
- PATCH /api/expenses/{id} - Atualiza uma despesa
- DELETE /api/expenses/{id} - Remove uma despesa

### Receitas

- POST /api/incomes - Cria uma receita
- GET /api/incomes - Lista receitas
- GET /api/incomes/{id} - Obtém uma receita
- PATCH /api/incomes/{id} - Atualiza uma receita
- DELETE /api/incomes/{id} - Remove uma receita

### Relatórios

- GET /api/reports/monthly-summary - Resumo mensal
- GET /api/reports/yearly-summary - Resumo anual
- GET /api/reports/recurring-expenses - Despesas recorrentes
- GET /api/reports/recurring-incomes - Receitas recorrentes
- GET /api/reports/category-trends - Tendências por categoria

## Autenticação

A API utiliza autenticação JWT. Para acessar endpoints protegidos, inclua o token no header:

```
Authorization: Bearer {seu-token}
```

## Paginação

Endpoints de listagem suportam paginação através dos parâmetros:

- page: Número da página (default: 1)
- per_page: Itens por página (default: 10)
